<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        $this->call([
            SettingsSeeder::class,
            RolePermissionSeeder::class,
        ]);

        $user = User::factory()->create([
            'name' => 'Super Admin',
            'email' => 'super@admin.com',
        ]);

        $user->assignRole(['Super Admin', 'admin']);

        $this->call([
            CountrySeeder::class,
            StateSeeder::class,
            CitySeeder::class,
            CategorySeeder::class,
            DestinationSeeder::class,
            PackageSeeder::class,
        ]);
    }
}
